﻿var includeFiles = {
    context: $(".v-includeFiles"),
    questionnaireId: 0,
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-includeFilesTable", this.context).a4datatable({
            displayLength: 20,
            height: "full",
            ajaxAction: a4.getAction("GetIncludeFiles", "Home", "Project"),
            ajaxParams: { questionnaireId: includeFiles.questionnaireId },
            columns: [
                { "Title": resources.Filename, "Data": "Filename", "HideInSelector": true },
                { "Title": resources.ModifiedBy, "Data": "ModifiedBy" },
                { "Title": resources.ModifiedOn, "Data": "ModifiedOn", "Type": "datetime" }
            ],
            toolBarItems: [
                { "Action": "download", "Label": resources.DownloadZip, "Visible": voxco.security.has('READ') },
                { "Action": "delete", "Label": resources.Delete, "Visible": voxco.security.has('DELETE') }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var filenames = _.pluck(rows, "Filename");

                switch (action) {
                    case "download":
                        window.location = a4.getAction("DownloadIncludeFiles", "Home", "Project", { questionnaireId: includeFiles.questionnaireId, filenames: filenames });
                        break;
                    case "delete":
                        includeFiles.delete(filenames);
                        break;
                }
            },
            contextMenuItems: [
                { "Action": "download", "Label": resources.Download, "DisplayCondition": function () { return voxco.security.has('READ'); } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function () { return voxco.security.has('DELETE'); } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "download":
                        window.location = a4.getAction("DownloadIncludeFile", "Home", "Project", { questionnaireId: includeFiles.questionnaireId, filename: row.Filename });
                        break;
                    case "delete":
                        includeFiles.delete([row.Filename]);
                        break;
                }
            },
            localizableTexts: { "Search": resources.Search }
        });
    },
    delete: function (filenames) {
        modalDialog.showConfirmDelete(confirmDelete, function () {
            a4.callServerMethod(a4.getAction("DeleteIncludeFiles", "Home", "Project"), { questionnaireId: includeFiles.questionnaireId, filenames: filenames }, function (result) {
                includeFiles.refreshContent();
            });
        }, filenames.length);
    },
    bindEvents: function () {
        $(".h-upload", includeFiles.context).on("click", function () {
            modalDialog.showWindow(a4.getAction("UploadIncludeFiles", "Home", "Project", { questionnaireId: includeFiles.questionnaireId }), 220, 600, { afterClose: includeFiles.refreshContent });
        });
    },
    refreshContent: function () {
        includeFiles.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (includeFiles.context.length > 0) {
        includeFiles.questionnaireId = $("#QuestionnaireId", includeFiles.context).val();
        includeFiles.initializeDataTable();
        includeFiles.bindEvents();
    }
});